/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.util.StringUtils;
import java.util.Locale;

public class GPSStatusBlock
extends DataBlock {
    private short speedInKnots;
    private int UTC;
    private byte numSats;
    private short altitudeHightInMeter;

    public GPSStatusBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("Speed GPS");
        this.measurementNames.add("UTC GPS");
        this.measurementNames.add("Satellites GPS");
        this.measurementNames.add("Altitude GPShigh");
        this.measurementUnits.add("Knots");
        this.measurementUnits.add("");
        this.measurementUnits.add("#");
        this.measurementUnits.add("m");
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
    }

    public GPSStatusBlock(GPSStatusBlock that) {
        super(that);
        this.speedInKnots = that.speedInKnots;
        this.UTC = that.UTC;
        this.numSats = that.numSats;
        this.altitudeHightInMeter = that.altitudeHightInMeter;
    }

    private void decode(byte[] rawData) {
        this.speedInKnots = Short.parseShort(StringUtils.bcdEncodeInverted(rawData, 6, 2));
        this.UTC = Integer.parseInt(StringUtils.bcdEncodeInverted(rawData, 8, 4));
        this.numSats = Byte.parseByte(StringUtils.bcdEncodeInverted(rawData, 12, 1));
        this.altitudeHightInMeter = Short.parseShort(StringUtils.bcdEncodeInverted(rawData, 13, 1));
        this.measurementValues.add(Integer.valueOf(this.getSpeedInTenthOfKnots()));
        this.measurementValues.add(this.getUTC());
        this.measurementValues.add(Integer.valueOf(this.getNumSats()));
        this.measurementValues.add(Integer.valueOf(this.getAltitudeHightInMeter()));
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof GPSStatusBlock) {
            GPSStatusBlock gpsStatus = (GPSStatusBlock)block;
            return gpsStatus.speedInKnots == this.speedInKnots && gpsStatus.UTC == this.UTC && gpsStatus.numSats == this.numSats && gpsStatus.altitudeHightInMeter == this.altitudeHightInMeter;
        }
        return false;
    }

    public short getSpeedInTenthOfKnots() {
        return this.speedInKnots;
    }

    public int getUTC() {
        return this.UTC;
    }

    public String getUTCString() {
        String utc = "" + this.UTC;
        return utc.length() == 8 ? String.valueOf(utc.substring(0, 2)) + ":" + utc.substring(2, 4) + ":" + utc.substring(4, 6) + "." + utc.substring(6, 8) : "00:00:00.00";
    }

    public byte getNumSats() {
        return this.numSats;
    }

    public short getAltitudeHightInMeter() {
        return this.altitudeHightInMeter;
    }

    @Override
    public String toString() {
        return "GPSStatusData:    " + this.getTimestamp() + " - speedInKnots = " + String.format(Locale.ENGLISH, "%.1f", (double)this.getSpeedInTenthOfKnots() * 0.1) + ", UTC = " + this.getUTCString() + ", numSats = " + this.getNumSats() + ", altitudeHightInMeter = " + this.getAltitudeHightInMeter();
    }
}

