/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.Serializable;
import org.eclipse.swt.SWT;

public final class RGB
implements Serializable {
    public int red;
    public int green;
    public int blue;
    static final long serialVersionUID = 3258415023461249074L;

    public RGB(int red, int green, int blue) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public RGB(float hue, float saturation, float brightness) {
        float r2;
        float g2;
        float b2;
        if (hue < 0.0f || hue > 360.0f || saturation < 0.0f || saturation > 1.0f || brightness < 0.0f || brightness > 1.0f) {
            SWT.error(5);
        }
        if (saturation == 0.0f) {
            g2 = b2 = brightness;
            r2 = b2;
        } else {
            if (hue == 360.0f) {
                hue = 0.0f;
            }
            int i2 = (int)(hue /= 60.0f);
            float f2 = hue - (float)i2;
            float p2 = brightness * (1.0f - saturation);
            float q2 = brightness * (1.0f - saturation * f2);
            float t2 = brightness * (1.0f - saturation * (1.0f - f2));
            switch (i2) {
                case 0: {
                    r2 = brightness;
                    g2 = t2;
                    b2 = p2;
                    break;
                }
                case 1: {
                    r2 = q2;
                    g2 = brightness;
                    b2 = p2;
                    break;
                }
                case 2: {
                    r2 = p2;
                    g2 = brightness;
                    b2 = t2;
                    break;
                }
                case 3: {
                    r2 = p2;
                    g2 = q2;
                    b2 = brightness;
                    break;
                }
                case 4: {
                    r2 = t2;
                    g2 = p2;
                    b2 = brightness;
                    break;
                }
                default: {
                    r2 = brightness;
                    g2 = p2;
                    b2 = q2;
                }
            }
        }
        this.red = (int)((double)(r2 * 255.0f) + 0.5);
        this.green = (int)((double)(g2 * 255.0f) + 0.5);
        this.blue = (int)((double)(b2 * 255.0f) + 0.5);
    }

    public float[] getHSB() {
        float saturation;
        float r2 = (float)this.red / 255.0f;
        float g2 = (float)this.green / 255.0f;
        float b2 = (float)this.blue / 255.0f;
        float max = Math.max(Math.max(r2, g2), b2);
        float min = Math.min(Math.min(r2, g2), b2);
        float delta = max - min;
        float hue = 0.0f;
        float brightness = max;
        float f2 = saturation = max == 0.0f ? 0.0f : (max - min) / max;
        if (delta != 0.0f) {
            hue = r2 == max ? (g2 - b2) / delta : (g2 == max ? 2.0f + (b2 - r2) / delta : 4.0f + (r2 - g2) / delta);
            if ((hue *= 60.0f) < 0.0f) {
                hue += 360.0f;
            }
        }
        return new float[]{hue, saturation, brightness};
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RGB)) {
            return false;
        }
        RGB rgb = (RGB)object;
        return rgb.red == this.red && rgb.green == this.green && rgb.blue == this.blue;
    }

    public int hashCode() {
        return this.blue << 16 | this.green << 8 | this.red;
    }

    public String toString() {
        return "RGB {" + this.red + ", " + this.green + ", " + this.blue + "}";
    }
}

