/*
 * Decompiled with CFR 0.152.
 */
package gde.device.resource;

import gde.config.Settings;
import gde.log.Level;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class DeviceXmlResource {
    private static final Logger log = Logger.getLogger(DeviceXmlResource.class.getName());
    private static DeviceXmlResource instance = null;
    private static ResourceBundle deviceXmlResources = null;

    private DeviceXmlResource() {
    }

    public static DeviceXmlResource getInstance() {
        if (instance == null) {
            deviceXmlResources = PropertyResourceBundle.getBundle("gde.device.resource.devicexmlresources", Settings.getInstance().getLocale());
            instance = new DeviceXmlResource();
        }
        return instance;
    }

    public boolean isKey(String key) {
        try {
            deviceXmlResources.getString(key);
        }
        catch (MissingResourceException e) {
            return false;
        }
        return true;
    }

    public String getReplacement(String key) {
        String replacement = key;
        if (!this.isKey(key)) {
            if (key.length() > 0 && !Character.isUpperCase(key.charAt(0)) && !Character.isDigit(key.charAt(0))) {
                String subKey;
                String string = subKey = key.indexOf(") ") >= 0 ? key.substring(key.indexOf(") ") + 2) : key;
                if (!this.isKey(subKey)) {
                    String string2 = subKey = subKey.indexOf(32) >= 3 ? subKey.substring(0, subKey.indexOf(32)) : subKey;
                    if (!this.isKey(subKey)) {
                        String string3 = subKey = subKey.lastIndexOf(95) >= 3 ? subKey.substring(0, subKey.lastIndexOf(95)) : subKey;
                        if (!this.isKey(subKey)) {
                            String string4 = subKey = subKey.lastIndexOf(40) >= 3 ? subKey.substring(0, subKey.lastIndexOf(40)) : subKey;
                            if (!this.isKey(subKey)) {
                                log.log(Level.WARNING, String.format("Finding a replacement for key = '%s' failed, using key as replacement value", key));
                            } else {
                                replacement = String.format("%s%s", deviceXmlResources.getString(subKey), key.substring(key.lastIndexOf(40)));
                            }
                        } else {
                            replacement = String.format("%s%s", deviceXmlResources.getString(subKey), key.substring(key.lastIndexOf(95)));
                        }
                    } else {
                        replacement = key.indexOf(") ") >= 0 ? String.format("%s%s%s", key.substring(0, key.indexOf(") ") + 2), deviceXmlResources.getString(subKey), key.substring(key.lastIndexOf(32))) : String.format("%s%s", deviceXmlResources.getString(subKey), key.substring(key.lastIndexOf(32)));
                    }
                } else {
                    replacement = String.format("%s%s", key.substring(0, key.indexOf(") ") + 2), deviceXmlResources.getString(subKey));
                }
            }
        } else {
            replacement = deviceXmlResources.getString(key);
        }
        return replacement;
    }

    public String[] getReplacements(String[] keys) {
        String[] replacements = new String[keys.length];
        for (int i = 0; i < replacements.length; ++i) {
            replacements[i] = this.getReplacement(keys[i]);
        }
        return replacements;
    }

    public static void reloadResources() {
        deviceXmlResources = PropertyResourceBundle.getBundle("gde.device.resource.devicexmlresources", Settings.getInstance().getLocale());
    }
}

