/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.BaseFont;
import java.util.ArrayList;

public class FontSelector {
    protected ArrayList<Font> fonts = new ArrayList();
    protected Font currentFont = null;

    public void addFont(Font font) {
        if (font.getBaseFont() != null) {
            this.fonts.add(font);
            return;
        }
        BaseFont bf = font.getCalculatedBaseFont(true);
        Font f2 = new Font(bf, font.getSize(), font.getCalculatedStyle(), font.getColor());
        this.fonts.add(f2);
    }

    public Phrase process(String text2) {
        if (this.fonts.size() == 0) {
            throw new IndexOutOfBoundsException(MessageLocalization.getComposedMessage("no.font.is.defined", new Object[0]));
        }
        char[] cc = text2.toCharArray();
        int len = cc.length;
        StringBuffer sb = new StringBuffer();
        Phrase ret = new Phrase();
        this.currentFont = null;
        for (int k2 = 0; k2 < len; ++k2) {
            Chunk newChunk = this.processChar(cc, k2, sb);
            if (newChunk == null) continue;
            ret.add(newChunk);
        }
        if (sb.length() > 0) {
            Chunk ck = new Chunk(sb.toString(), this.currentFont != null ? this.currentFont : this.fonts.get(0));
            ret.add(ck);
        }
        return ret;
    }

    protected Chunk processChar(char[] cc, int k2, StringBuffer sb) {
        Chunk newChunk = null;
        char c2 = cc[k2];
        if (c2 == '\n' || c2 == '\r') {
            sb.append(c2);
        } else {
            Font font = null;
            if (Utilities.isSurrogatePair(cc, k2)) {
                int u2 = Utilities.convertToUtf32(cc, k2);
                for (int f2 = 0; f2 < this.fonts.size(); ++f2) {
                    font = this.fonts.get(f2);
                    if (!font.getBaseFont().charExists(u2) && Character.getType(u2) != 16) continue;
                    if (this.currentFont != font) {
                        if (sb.length() > 0 && this.currentFont != null) {
                            newChunk = new Chunk(sb.toString(), this.currentFont);
                            sb.setLength(0);
                        }
                        this.currentFont = font;
                    }
                    sb.append(c2);
                    sb.append(cc[++k2]);
                    break;
                }
            } else {
                for (int f3 = 0; f3 < this.fonts.size(); ++f3) {
                    font = this.fonts.get(f3);
                    if (!font.getBaseFont().charExists(c2) && Character.getType(c2) != 16) continue;
                    if (this.currentFont != font) {
                        if (sb.length() > 0 && this.currentFont != null) {
                            newChunk = new Chunk(sb.toString(), this.currentFont);
                            sb.setLength(0);
                        }
                        this.currentFont = font;
                    }
                    sb.append(c2);
                    break;
                }
            }
        }
        return newChunk;
    }
}

